unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  Registry;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    btnCLOSE: TBitBtn;
    btnCZYTAJ: TBitBtn;
    btnUTW_GALAZ: TBitBtn;
    btnUTW_KLUCZE: TBitBtn;
    btnUSUN_GALAZ: TBitBtn;
    procedure btnUSUN_GALAZClick(Sender: TObject);
    procedure btnUTW_KLUCZEClick(Sender: TObject);
    procedure btnUTW_GALAZClick(Sender: TObject);
    procedure btnCZYTAJClick(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm2.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TForm2.btnCZYTAJClick(Sender: TObject);
var
	klucz   : String;
   wartosc : String;
   reg     : TRegistry;

begin
   klucz   := '';
   wartosc := '';
   reg     := TRegistry.Create();

   reg.RootKey := HKEY_CURRENT_USER;

   klucz := 'Software\Borland\BDS\5.0\Editor\Options';

   if reg.OpenKey(klucz, false) then
   begin
      wartosc := reg.ReadString('Editor Emulation');
   	ShowMessage(wartosc);
   end
   else begin
      ShowMessage('Poszukiwany klucz: ' + #10#13 +
                  klucz + #10#13 +
                  'nie zosta znaleziony');
   end;

   FreeAndNil(reg);
end;

procedure TForm2.btnUTW_GALAZClick(Sender: TObject);
var
   reg   : TRegistry;
   isOK  : Boolean;
   klucz : String;

begin
	isOK := false;
   reg  := TRegistry.Create();

   // jezei nie podamy tej wartoci zostanie somylnie wybrany
   // HKEY_CURRENT_USER;
   // reg->RootKey = HKEY_CURRENT_USER;

   klucz := 'NOWY_KLUCZ_HELION_DELPHI_2007';
   isOK  := reg.OpenKey(klucz, true);

   if isOK then
   begin
	   ShowMessage('Nowa ga ' + klucz + #10#13 + 'utworzona prawidowo');
   end;

	if Assigned(reg) then
   begin
		FreeAndNil(reg);
   end;
end;

procedure TForm2.btnUTW_KLUCZEClick(Sender: TObject);
var
   reg     : TRegistry;
   isOK    : Boolean;
   dzisiaj : TDate;
   klucz   : String;

begin
	isOK    := false;
   dzisiaj := Date();
   klucz   := 'NOWY_KLUCZ_HELION_DELPHI_2007';

   reg         := TRegistry.Create();
   reg.RootKey := HKEY_CURRENT_USER;

   isOK := reg.OpenKey(klucz, false);
   if isOK then
	begin
   	try
         reg.WriteString('Nazwa_aplikacji', 'PROJ_REJESTR');
         reg.WriteDate('DATA', dzisiaj);
   	except
         ShowMessage('Nieudany zapis do klucza rejestru');
      end;
   end;

	FreeAndNil(reg);
end;

procedure TForm2.btnUSUN_GALAZClick(Sender: TObject);
var
   reg     : TRegistry;
   isOK    : Boolean;
   klucz   : String;

begin
	isOK    := false;
   klucz   := 'NOWY_KLUCZ_HELION_DELPHI_2007';

   reg         := TRegistry.Create();
   reg.RootKey := HKEY_CURRENT_USER;
   try
      reg.DeleteKey(klucz);  // wykasowanie klucza
      ShowMessage('Ga i klucze usunite prawidowo');
   finally
 		FreeAndNil(reg);
   end;
end;

end.


